// Name and Surname
// Grade 12
// Information Technology
// Paper 1
// September 2025

unit Question2_U;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, StdCtrls, ComCtrls, ExtCtrls, dbConnection_u, DB,
  ADODB;

type
  TfrmQuestion2 = class(TForm)
    btnRestoreDB: TButton;
    pgcSolarSystem: TPageControl;
    tbsSQL: TTabSheet;
    tbsADO: TTabSheet;
    btn2_1_1: TButton;
    btn2_1_2: TButton;
    btn2_1_3: TButton;
    btn2_1_4: TButton;
    btn2_2_1: TButton;
    btn2_2_2: TButton;
    redOutput: TRichEdit;
    dbgSql: TDBGrid;
    dbgPlanets: TDBGrid;
    dbgMissions: TDBGrid;
    lblPlanets: TLabel;
    lblMissions: TLabel;
    pnlSQLGrid: TPanel;
    pnlButtons: TPanel;
    pnlTop: TPanel;
    pnlMain: TPanel;
    pnlLeft: TPanel;
    pnlRight: TPanel;
    btn2_1_5: TButton;
    btnMissions: TButton;
    btnPlanets: TButton;
    cmbPlanets: TComboBox;
    procedure btnRestoreDBClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btn2_1_1Click(Sender: TObject);
    procedure btn2_1_2Click(Sender: TObject);
    procedure btn2_1_3Click(Sender: TObject);
    procedure btn2_1_4Click(Sender: TObject);
    procedure btn2_1_5Click(Sender: TObject);
    procedure btn2_2_2Click(Sender: TObject);
    procedure btn2_2_1Click(Sender: TObject);
    procedure btnPlanetsClick(Sender: TObject);
    procedure btnMissionsClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure pgcSolarSystemChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetGridColumnWidths(Grid: Tdbgrid);
  end;

var
  frmQuestion2: TfrmQuestion2;
  // Provided code - DO NOT DELETE OR ALTER //
  dbCONN  : TConnection;
  qryInfo : TADOQuery;
  tblPlanets, tblMissions : TADOTable;

implementation

{$R *.dfm}
{$R+}

// ===========================================================
//                Question 2.1.1 - 6 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_1_1Click(Sender: TObject);
// Provided code - DO NOT DELETE OR ALTER //
var
  sSQL1: String;
begin
  /// Enter your code below ///
  sSQL1 := '';

  // Provided code - DO NOT DELETE OR ALTER //
  dbCONN.runSQL(sSQL1);
  if length(sSQL1) <> 0 then
    SetGridColumnWidths(dbgSQL);
end;

// ===========================================================
//                Question 2.1.2 - 6 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_1_2Click(Sender: TObject);
// Provided code - DO NOT DELETE OR ALTER //
var
   sSQL2: String;
begin
  /// Enter your code below ///
  sSQL2 := '';

  // Provided code - DO NOT DELETE OR ALTER //
  dbCONN.runSQL(sSQL2);
  if length(sSQL2) <> 0 then
    SetGridColumnWidths(dbgSQL);
end;

// ===========================================================
//                Question 2.1.3 - 4 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_1_3Click(Sender: TObject);
// Provided code - DO NOT DELETE OR ALTER //
var
  sSQL3 : String;
  sLine : String;
begin
  /// Enter your code below ///
  sSQL3 := '';

  // Provided code - DO NOT DELETE OR ALTER //
  dbCONN.executeSQL(sSQL3,dbgPlanets,dbgMissions,dbgSQL);
  if length(sSQL3) <> 0 then
    SetGridColumnWidths(dbgSQL);
end;

// ===========================================================
//                Question 2.1.4 - 6 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_1_4Click(Sender: TObject);
// Provided code - DO NOT DELETE OR ALTER //
var
  sSQL4: String;
  sYear: String;
begin
  /// Enter your code below ///

  sSQL4 := '' ;

  // Provided code - DO NOT DELETE OR ALTER //
  dbCONN.executeSQL(sSQL4,dbgPlanets,dbgMissions,dbgSQL);
  if length(sSQL4) <> 0 then
    SetGridColumnWidths(dbgSQL);
end;

// ===========================================================
//                Question 2.1.5 - 6 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_1_5Click(Sender: TObject);
// Provided code - DO NOT DELETE OR ALTER //
var
  sSQL5: String;
begin
  /// Enter your code below ///
  sSQL5 := '';

  // Provided code - DO NOT DELETE OR ALTER //
  dbCONN.runSQL(sSQL5);
  if length(sSQL5) <> 0 then
    SetGridColumnWidths(dbgSQL);
end;

// ===========================================================
//                Question 2.2.1 - 2 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_2_1Click(Sender: TObject);
begin
  // Provided code - DO NOT DELETE OR ALTER //
  with redOutput do
    begin
      Clear;
      SelAttributes.Style := [fsBold];
      Lines.Add('Solar System');
    end;
  /// Enter your code below ///

end;

// ===========================================================
//                Question 2.2.2 - 10 Marks
// ===========================================================
procedure TfrmQuestion2.btn2_2_2Click(Sender: TObject);
var
  sPlanetName, sAgency, sMission: String;
  iPlanetID: Integer;
begin
  // Provided code - DO NOT DELETE OR ALTER //
  redOutput.Clear;
  if cmbPlanets.ItemIndex = -1 then
    begin
      dbCONN.ErrorMessage('Please select a planet');
      Exit;
    end;

  with tblPlanets do
    begin
      Open;
      First;
      /// Enter your code below ///
      
    end;
end;

/////////////////////////////////////////////////////////////////
//////////    Provided Code - DO NOT DELETE OR ALTER   //////////
/////////////////////////////////////////////////////////////////
{$REGION 'Setup Code'}
  //Setup DB connections - DO NOT CHANGE!
  procedure TfrmQuestion2.btnRestoreDBClick(Sender: TObject);
  begin
    // Restores the Database
    dbCONN.RestoreDatabase(dbgPlanets,dbgMissions,dbgSQL);
    // Formatting field datatypes
    tblPlanets  := dbconn.tblOne;
    tblMissions := dbCONN.tblMany;
    qryInfo     := dbCONN.qrySolar;
	  SetGridColumnWidths(dbgPlanets);
 	  SetGridColumnWidths(dbgMissions);
    //SetGridColumnWidths(dbgSQL);
  end;

  procedure TfrmQuestion2.FormActivate(Sender: TObject);
  var
    AnsW: string;
  begin
    frmQuestion2.Caption := 'Question 2 - Database programming: SQL';
    frmQuestion2.Width  := 750;
    frmQuestion2.Height := 600;
    frmQuestion2.Constraints.MinWidth  := 650;
    frmQuestion2.Constraints.MinHeight := 500;
    // Sets up the connection to database and opens the tables.
    dbCONN := TConnection.Create;
    dbCONN.dbConnect;
    tblPlanets  := dbCONN.tblOne;
    tblMissions := dbCONN.tblMany;
    qryInfo     := dbCONN.qrySolar;
    dbCONN.setupGrids(dbgPlanets,dbgMissions,dbgSQL);
    pgcSolarSystem.TabIndex := 0;
    SetGridColumnWidths(dbgPlanets);
    SetGridColumnWidths(dbgMissions);
    with redOutput do
    begin
      Clear;
      Paragraph.TabCount := 1;
      Paragraph.Tab[0]   := 80;
    end;
    cmbPlanets.Text := 'Planets';
  end;

  procedure TfrmQuestion2.FormClose(Sender: TObject; var Action: TCloseAction);
  begin // Disconnects from database and closes all open connections
    dbCONN.dbDisconnect;
  end;

  procedure TfrmQuestion2.FormResize(Sender: TObject);
  begin
    pnlTop.Height  := pnlMain.Height DIV 2;
    pnlLeft.Width  := Round(pnlMain.Width * 0.65);
  end;

  procedure TfrmQuestion2.pgcSolarSystemChange(Sender: TObject);
  begin
    case pgcSolarSystem.TabIndex of
      0 : frmQuestion2.Caption := 'Question 2 - Database programming: SQL';
      1 : begin
            frmQuestion2.Caption := 'Question 2 - Database programming: Delphi code';
            dbCONN.setupGrids(dbgPlanets,dbgMissions,dbgSQL);
            SetGridColumnWidths(dbgPlanets);
            SetGridColumnWidths(dbgMissions);
          end;
    end;
  end;

procedure TfrmQuestion2.SetGridColumnWidths(Grid: Tdbgrid);
  const
    DEFBORDER = 10;
  var
    temp, n: Integer;
    lmax: array [0..30] of Integer;
  begin
    with Grid do
    begin
      Canvas.Font := Font;
      for n := 0 to Columns.Count - 1 do
        lmax[n] := Canvas.TextWidth(Fields[n].FieldName) + DEFBORDER;
      grid.DataSource.DataSet.First;
      while not grid.DataSource.DataSet.EOF do
      begin
        for n := 0 to Columns.Count - 1 do
        begin
          temp := Canvas.TextWidth(trim(Columns[n].Field.DisplayText)) + DEFBORDER;
          if temp > lmax[n] then lmax[n] := temp;
        end; {for}
        grid.DataSource.DataSet.Next;
      end;
      grid.DataSource.DataSet.First;
      for n := 0 to Columns.Count - 1 do
        if lmax[n] > 0 then
          Columns[n].Width := lmax[n];
    end;
  end; {SetGridColumnWidths}

  procedure TfrmQuestion2.btnMissionsClick(Sender: TObject);
  begin
    dbCONN.DisplayAll(qryInfo,'tblMissions');
    SetGridColumnWidths(dbgSQL);
  end;

  procedure TfrmQuestion2.btnPlanetsClick(Sender: TObject);
  begin
    dbCONN.DisplayAll(qryInfo,'tblPlanets');
    SetGridColumnWidths(dbgSQL);
  end;
{$ENDREGION}

end.
